//AIM:Computation of N-Point DFT using DIT method.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will compute the DFT of the sequence x(n)={0,0.25,0.5,0.75,1,0.75,0.5,0.25,0} 
//using DIT(Split radix) method for N=9(3*3)
//Let us begin with the programming.For understanding,let us write the given data as
//x(0)=0;x(1)=0.25,x(2)=0.5,x(3)=0.75,x(4)=1,x(5)=0.75,x(6)=0.5,x(7)=0.25,x(8)=0
x0=0;
x3=0.75;
x6=0.5;
x1=0.25;
x4=1;
x7=0.25;
x2=0.5;
x5=0.75;
x8=0;
W0=cos((2*%pi/9)*0)-(sqrt(-1))*sin((2*%pi/9)*0)
disp(W0,'W0=')
W1=cos((2*%pi/9)*1)-(sqrt(-1))*sin((2*%pi/9)*1)
disp(W1,'W1=')
W2=cos((2*%pi/9)*2)-(sqrt(-1))*sin((2*%pi/9)*2)
disp(W2,'W2=')
W3=cos((2*%pi/9)*3)-(sqrt(-1))*sin((2*%pi/9)*3)
disp(W3,'W3=')
W4=cos((2*%pi/9)*4)-(sqrt(-1))*sin((2*%pi/9)*4)
disp(W4,'W4=')
W5=cos((2*%pi/9)*5)-(sqrt(-1))*sin((2*%pi/9)*5)
disp(W5,'W5=')
W6=cos((2*%pi/9)*6)-(sqrt(-1))*sin((2*%pi/9)*6)
disp(W6,'W6=')
W7=cos((2*%pi/9)*7)-(sqrt(-1))*sin((2*%pi/9)*7)
disp(W7,'W7=')
W8=cos((2*%pi/9)*8)-(sqrt(-1))*sin((2*%pi/9)*8)
disp(W8,'W8=')
//Stage I computation
X0a=x0+x3+x6;
disp(X0a,'Stage-I output at line 1=')
X3b=x0+x3*W3+x6*W6;//at line 2 x3,x6 are to be multiplied by twiddle factor W3 and W6 respectively
disp(X3b,'Stage-I output at line 2=')
X6c=x0+x3*W6+x6*W3;//at line 3 x3,x6 are to be multiplied by twiddle factor W6 and W3 respectively
disp(X6c,'Stage-I output at line 3=')
X1d=x1+x4+x7;
disp(X1d,'Stage-I output at line 4=')
X4e=x1+x4*W3+x7*W6;//at line 4 x3,x6 are to be multiplied by twiddle factor W3 and W6 respectively
disp(X4e,'Stage-I output at line 5=')
X7f=x1+x4*W6+x7*W3;//at line 2 x3,x6 are to be multiplied by twiddle factor W6 and W3 respectively
disp(X7f,'Stage-I output at line 6=')
X2g=x2+x5+x8;
disp(X2g,'Stage-I output at line 7=')
X5h=x2+x5*W3+x8*W6;//at line 2 x3,x6 are to be multiplied by twiddle factor W3 and W6 respectively
disp(X5h,'Stage-I output at line 8=')
X8i=x2+x5*W6+x8*W3;//at line 2 x3,x6 are to be multiplied by twiddle factor W6 and W3 respectively
disp(X8i,'Stage-I output at line 9=')

//Stage II computation
X0=X0a+X1d+X2g;
disp(X0,'Stage-II output at line 1=')
X1=X3b+X4e*W1+X5h*W2;//at line 2 X4e,X5h are to be multiplied by twiddle factor W1 and W2 respectively
disp(X1,'Stage-II output at line 2=')
X2=X6c+X7f*W2+X8i*W4;//at line 2 X7f,X8i are to be multiplied by twiddle factor W2 and W4 respectively
disp(X2,'Stage-II output at line 3=')
X3=X0a+X1d*W3+X2g*W6;//at line 2 X1d,X2g are to be multiplied by twiddle factor W3 and W6 respectively
disp(X3,'Stage-II output at line 4=')
X4=X3b+X4e*W4+X5h*W8;//at line 2 X4e,X5h are to be multiplied by twiddle factor W4 and W8 respectively
disp(X4,'Stage-II output at line 5=')
X5=X6c+X7f*W5+X8i*W1;//at line 2 X7f,X8i are to be multiplied by twiddle factor W5 and W10 respectively
disp(X5,'Stage-II output at line 6=')
X6=X0a+X1d*W6+X2g*W3;//at line 2 X1d,X2g are to be multiplied by twiddle factor W6 and W3 respectively
disp(X6,'Stage-II output at line 7=')
X7=X3b+X4e*W7+X5h*W5;//at line 2 X4e,X5h are to be multiplied by twiddle factor W7 and W5 respectively
disp(X7,'Stage-II output at line 8=')
X8=X6c+X7f*W8+X8i*W7;//at line 2 X7f,X8i are to be multiplied by twiddle factor W8 and W7 respectively
disp(X8,'Stage-II output at line 9=')
disp({X0,X1,X2,X3,X4,X5,X6,X7,X8},'So,the DFT of x(n) using Decimation-in-Time Fast Fourier Transform(DIT-FFT) is X(k)=')

//Expected output:{4,-1.9477148-0.7089102i,0.0542204+0.0454963i,-0.125-0.2165064i,0.0184945+0.1048875i,
//0.0184945-0.1048875i,-0.125+0.2165064i,0.0542204-0.0454963i,-1.9477148+0.7089102i}  

